/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth;

import java.util.Arrays;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
final class GuiPasswordField
extends GuiTextField {
    private char[] password = new char[0];

    GuiPasswordField(FontRenderer renderer, int posx, int posy, int x, int y) {
        super(1, renderer, posx, posy, x, y);
        this.func_146203_f(512);
    }

    final char[] getPW() {
        char[] pw = new char[this.password.length];
        System.arraycopy(this.password, 0, pw, 0, this.password.length);
        return pw;
    }

    public final boolean func_146201_a(char typedChar, int keyCode) {
        if (!this.func_146206_l() || GuiScreen.func_175280_f((int)keyCode) || GuiScreen.func_175277_d((int)keyCode)) {
            return false;
        }
        if (GuiScreen.func_175278_g((int)keyCode) || GuiScreen.func_175279_e((int)keyCode)) {
            return super.func_146201_a(typedChar, keyCode);
        }
        switch (keyCode) {
            case 14: 
            case 199: 
            case 203: 
            case 205: 
            case 207: 
            case 211: {
                return super.func_146201_a(typedChar, keyCode);
            }
        }
        if (this.isAllowedCharacter(typedChar)) {
            this.func_146191_b(Character.toString(typedChar));
            return true;
        }
        return false;
    }

    public final void func_146191_b(String rawInput) {
        int selStart = this.func_146198_h() < this.func_146186_n() ? this.func_146198_h() : this.func_146186_n();
        int selEnd = this.func_146198_h() < this.func_146186_n() ? this.func_146186_n() : this.func_146198_h();
        char[] input = this.filterAllowedCharacters(rawInput).toCharArray();
        char[] newPW = new char[selStart + this.password.length - selEnd + input.length];
        if (this.password.length != 0 && selStart > 0) {
            System.arraycopy(this.password, 0, newPW, 0, Math.min(selStart, this.password.length));
        }
        System.arraycopy(input, 0, newPW, selStart, input.length);
        int l = input.length;
        if (this.password.length != 0 && selEnd < this.password.length) {
            System.arraycopy(this.password, selEnd, newPW, selStart + input.length, this.password.length - selEnd);
        }
        this.setPassword(newPW);
        Arrays.fill(newPW, 'f');
        this.func_146182_d(selStart - this.func_146186_n() + l);
    }

    public final void func_146175_b(int num) {
        if (this.password.length == 0) {
            return;
        }
        if (this.func_146186_n() != this.func_146198_h()) {
            this.func_146191_b("");
        } else {
            boolean direction = num < 0;
            int start = direction ? Math.max(this.func_146198_h() + num, 0) : this.func_146198_h();
            int end = direction ? this.func_146198_h() : Math.min(this.func_146198_h() + num, this.password.length);
            char[] newPW = new char[start + this.password.length - end];
            if (start >= 0) {
                System.arraycopy(this.password, 0, newPW, 0, start);
            }
            if (end < this.password.length) {
                System.arraycopy(this.password, end, newPW, start, this.password.length - end);
            }
            this.setPassword(newPW);
            Arrays.fill(newPW, 'f');
            if (direction) {
                this.func_146182_d(num);
            }
        }
    }

    final void setPassword(char[] password) {
        Arrays.fill(this.password, 'f');
        this.password = new char[password.length];
        System.arraycopy(password, 0, this.password, 0, password.length);
        this.updateText();
    }

    public final void func_146180_a(String textIn) {
        this.setPassword(textIn.toCharArray());
        this.updateText();
    }

    private void updateText() {
        char[] chars = new char[this.password.length];
        Arrays.fill(chars, '\u25cf');
        super.func_146180_a(new String(chars));
    }

    private boolean isAllowedCharacter(int character) {
        return character == 167 || ChatAllowedCharacters.func_71566_a((char)((char)character));
    }

    private String filterAllowedCharacters(String input) {
        StringBuilder stringbuilder = new StringBuilder();
        input.chars().filter(this::isAllowedCharacter).forEach(i -> stringbuilder.append((char)i));
        return stringbuilder.toString();
    }
}

