/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.network;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import mrriegel.storagenetwork.gui.IStorageInventory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class StackRefreshClientMessage
implements IMessage,
IMessageHandler<StackRefreshClientMessage, IMessage> {
    private int size;
    private int csize;
    private List<ItemStack> stacks;
    private List<ItemStack> craftableStacks;

    public StackRefreshClientMessage() {
    }

    public StackRefreshClientMessage(List<ItemStack> stacks, List<ItemStack> craftableStacks) {
        this.stacks = stacks;
        this.craftableStacks = craftableStacks;
        this.size = stacks.size();
        this.csize = craftableStacks.size();
    }

    public IMessage onMessage(final StackRefreshClientMessage message, MessageContext ctx) {
        Minecraft mainThread = Minecraft.func_71410_x();
        mainThread.func_152344_a(new Runnable(){

            @Override
            public void run() {
                if (Minecraft.func_71410_x().field_71462_r instanceof IStorageInventory) {
                    IStorageInventory gui = (IStorageInventory)Minecraft.func_71410_x().field_71462_r;
                    gui.setStacks(message.stacks);
                    gui.setCraftableStacks(message.craftableStacks);
                }
            }
        });
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        ItemStack stack;
        int i;
        this.size = buf.readInt();
        this.csize = buf.readInt();
        this.stacks = Lists.newArrayList();
        for (i = 0; i < this.size; ++i) {
            stack = new ItemStack(ByteBufUtils.readTag((ByteBuf)buf));
            stack.func_190920_e(buf.readInt());
            this.stacks.add(stack);
        }
        this.craftableStacks = Lists.newArrayList();
        for (i = 0; i < this.csize; ++i) {
            stack = new ItemStack(ByteBufUtils.readTag((ByteBuf)buf));
            stack.func_190920_e(buf.readInt());
            this.craftableStacks.add(stack);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.size);
        buf.writeInt(this.csize);
        for (ItemStack stack : this.stacks) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)stack.serializeNBT());
            buf.writeInt(stack.func_190916_E());
        }
        for (ItemStack stack : this.craftableStacks) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)stack.serializeNBT());
            buf.writeInt(stack.func_190916_E());
        }
    }
}

