/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.block.control;

import java.util.ArrayList;
import java.util.List;
import mrriegel.storagenetwork.api.data.DimPos;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;

public class ProcessWrapper {
    public boolean alwaysOn;
    public String name;
    public DimPos pos;
    public ItemStack output;
    public int count;
    public List<ItemStack> ingredients;
    public ResourceLocation blockId;

    public ProcessWrapper(DimPos p, ItemStack s, int c, String name, boolean on) {
        this.pos = p;
        this.output = s;
        this.count = c;
        this.name = name;
        this.alwaysOn = on;
    }

    public ProcessWrapper() {
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.name = compound.func_74779_i("sname");
        this.blockId = new ResourceLocation(compound.func_74779_i("blockId"));
        this.alwaysOn = compound.func_74767_n("aon");
        this.pos = new DimPos(compound.func_74775_l("pos"));
        this.output = new ItemStack(compound);
        this.count = compound.func_74762_e("cou");
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.ingredients = new ArrayList<ItemStack>();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            this.ingredients.add(new ItemStack(nbttagcompound));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        this.output.func_77955_b(compound);
        compound.func_74778_a("blockId", this.blockId.toString());
        compound.func_74778_a("sname", this.name);
        compound.func_74757_a("aon", this.alwaysOn);
        compound.func_74782_a("pos", (NBTBase)this.pos.serializeNBT());
        compound.func_74768_a("cou", this.count);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.ingredients.size(); ++i) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            this.ingredients.get(i).func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        return compound;
    }
}

