/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.block.cable;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mrriegel.storagenetwork.block.cable.TileCable;
import mrriegel.storagenetwork.block.master.TileMaster;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileCableWithFacing
extends TileCable {
    @Nullable
    EnumFacing direction = null;

    public boolean hasDirection() {
        return this.direction != null;
    }

    public EnumFacing getDirection() {
        return this.direction;
    }

    public BlockPos getFacingPosition() {
        return this.func_174877_v().func_177972_a(this.direction);
    }

    public void setDirection(@Nullable EnumFacing direction) {
        this.direction = direction;
    }

    protected boolean isValidLinkNeighbor(EnumFacing facing) {
        if (facing == null) {
            return false;
        }
        if (!TileMaster.isTargetAllowed(this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(facing)))) {
            return false;
        }
        TileEntity neighbor = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
        return neighbor != null && neighbor.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
    }

    public void findNewDirection() {
        if (this.isValidLinkNeighbor(this.direction)) {
            return;
        }
        for (EnumFacing facing : EnumFacing.values()) {
            if (!this.isValidLinkNeighbor(facing)) continue;
            this.setDirection(facing);
            return;
        }
        this.setDirection(null);
    }

    public void rotate() {
        EnumFacing previous = this.direction;
        List<EnumFacing> targetFaces = Arrays.asList(EnumFacing.values());
        Collections.shuffle(targetFaces);
        for (EnumFacing facing : EnumFacing.values()) {
            TileMaster master;
            if (previous == facing || !this.isValidLinkNeighbor(facing)) continue;
            this.setDirection(facing);
            this.func_70296_d();
            if (previous != this.direction && (master = this.getTileMaster()) != null) {
                master.refreshNetwork();
            }
            return;
        }
    }

    public TileMaster getTileMaster() {
        if (this.getMaster() == null) {
            return null;
        }
        return this.getMaster().getTileEntity(TileMaster.class);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.direction = compound.func_74764_b("direction") ? EnumFacing.func_82600_a((int)compound.func_74762_e("direction")) : null;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.direction != null) {
            compound.func_74768_a("direction", this.direction.ordinal());
        }
        return super.func_189515_b(compound);
    }
}

