/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.thirdparty.IDocsProvider;
import me.desht.pneumaticcraft.common.thirdparty.IThirdParty;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public class Patchouli
implements IThirdParty,
IDocsProvider {
    private static GuiScreen prevGui;

    @Override
    public void clientPreInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void clientInit() {
        PatchouliAPI.IPatchouliAPI papi = PatchouliAPI.instance;
        this.setConfigFlags();
        IStateMatcher edge = papi.predicateMatcher(Blockss.PRESSURE_CHAMBER_WALL, this::validEdge);
        IStateMatcher wall = papi.predicateMatcher(Blockss.PRESSURE_CHAMBER_WALL, this::validFace);
        IStateMatcher glass = papi.predicateMatcher(Blockss.PRESSURE_CHAMBER_GLASS, this::validFace);
        IStateMatcher valve = papi.predicateMatcher(Blockss.PRESSURE_CHAMBER_VALVE.func_176223_P().func_177226_a(BlockPneumaticCraft.ROTATION, (Comparable)EnumFacing.NORTH), this::validFace);
        IStateMatcher valveUp = papi.predicateMatcher(Blockss.PRESSURE_CHAMBER_VALVE.func_176223_P().func_177226_a(BlockPneumaticCraft.ROTATION, (Comparable)EnumFacing.UP), this::validFace);
        IStateMatcher intI = papi.predicateMatcher(Blockss.PRESSURE_CHAMBER_INTERFACE.func_176223_P().func_177226_a(BlockPneumaticCraft.ROTATION, (Comparable)EnumFacing.EAST), this::validFace);
        IStateMatcher intO = papi.predicateMatcher(Blockss.PRESSURE_CHAMBER_INTERFACE.func_176223_P().func_177226_a(BlockPneumaticCraft.ROTATION, (Comparable)EnumFacing.WEST), this::validFace);
        IMultiblock pc3 = papi.makeMultiblock((String[][])new String[][]{{"WWW", "WWW", "WWW"}, {"WIW", "VAF", "WIW"}, {"WWW", "W0W", "WWW"}}, new Object[]{Character.valueOf('W'), edge, Character.valueOf('F'), glass, Character.valueOf('0'), wall, Character.valueOf('V'), valve, Character.valueOf('I'), intI, Character.valueOf('O'), intO, Character.valueOf('A'), papi.airMatcher()}).setSymmetrical(true);
        papi.registerMultiblock(PneumaticCraftUtils.RL("pressure_chamber_3"), pc3);
        IMultiblock pc4 = papi.makeMultiblock((String[][])new String[][]{{"WWWW", "WWWW", "WWWW", "WWWW"}, {"WFFW", "VAAF", "FAAF", "WFFW"}, {"WFFW", "VAAF", "FAAF", "WIOW"}, {"WWWW", "W0WW", "WWWW", "WWWW"}}, new Object[]{Character.valueOf('W'), edge, Character.valueOf('F'), glass, Character.valueOf('0'), wall, Character.valueOf('V'), valve, Character.valueOf('I'), intI, Character.valueOf('O'), intO, Character.valueOf('A'), papi.airMatcher()}).setSymmetrical(false);
        papi.registerMultiblock(PneumaticCraftUtils.RL("pressure_chamber_4"), pc4);
        IMultiblock pc5 = papi.makeMultiblock((String[][])new String[][]{{"WWWWW", "WWVWW", "WVWVW", "WWVWW", "WWWWW"}, {"WFFFW", "FAAAF", "FAAAF", "FAAAF", "WOFIW"}, {"WFFFW", "FAAAF", "FAAAF", "FAAAF", "WFFFW"}, {"WFFFW", "FAAAF", "FAAAF", "FAAAF", "WOFIW"}, {"WWWWW", "WWWWW", "WW0WW", "WWWWW", "WWWWW"}}, new Object[]{Character.valueOf('W'), edge, Character.valueOf('F'), glass, Character.valueOf('0'), wall, Character.valueOf('V'), valveUp, Character.valueOf('I'), intI, Character.valueOf('O'), intO, Character.valueOf('A'), papi.airMatcher()}).setSymmetrical(true);
        papi.registerMultiblock(PneumaticCraftUtils.RL("pressure_chamber_5"), pc5);
    }

    private boolean validEdge(IBlockState state) {
        return state.func_177230_c() == Blockss.PRESSURE_CHAMBER_WALL || state.func_177230_c() == Blockss.PRESSURE_CHAMBER_GLASS;
    }

    private boolean validFace(IBlockState state) {
        return state.func_177230_c() == Blockss.PRESSURE_CHAMBER_WALL || state.func_177230_c() == Blockss.PRESSURE_CHAMBER_GLASS || state.func_177230_c() == Blockss.PRESSURE_CHAMBER_INTERFACE || state.func_177230_c() == Blockss.PRESSURE_CHAMBER_VALVE;
    }

    private void setConfigFlags() {
        PatchouliAPI.instance.setConfigFlag("pneumaticcraft:liquidHopperDispenser", ConfigHandler.machineProperties.liquidHopperDispenser);
        PatchouliAPI.instance.setConfigFlag("pneumaticcraft:omniHopperDispenser", ConfigHandler.machineProperties.omniHopperDispenser);
        PatchouliAPI.instance.setConfigFlag("pneumaticcraft:electricCompressorEnabled", ConfigHandler.recipes.enableElectricCompressorRecipe && Loader.isModLoaded((String)"ic2"));
        PatchouliAPI.instance.setConfigFlag("pneumaticcraft:pneumaticGeneratorEnabled", ConfigHandler.recipes.enablePneumaticGeneratorRecipe && Loader.isModLoaded((String)"ic2"));
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("pneumaticcraft")) {
            this.setConfigFlags();
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (prevGui != null) {
            event.setGui(prevGui);
            prevGui = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void openBookGui(ResourceLocation bookRes, String entryId) {
        BookEntry entry;
        GuiScreen prev = Minecraft.func_71410_x().field_71462_r;
        Book book = (Book)BookRegistry.INSTANCE.books.get(bookRes);
        if (book != null && (entry = (BookEntry)book.contents.entries.get(new ResourceLocation(bookRes.func_110624_b(), entryId))) != null) {
            GuiBook curr = book.contents.getCurrentGui();
            book.contents.currentGui = new GuiBookEntry(book, entry, 0);
            book.contents.guiStack.push(curr);
            book.contents.openLexiconGui(book.contents.getCurrentGui(), true);
            prevGui = prev;
        }
    }

    @Override
    public void showWidgetDocs(String path) {
        Patchouli.openBookGui(PneumaticCraftUtils.RL("book"), "programming/" + path);
    }

    @Override
    public boolean docsProviderInstalled() {
        return true;
    }
}

