/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data;

import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import com.bloodnbonesgaming.triumph.config.data.MinMaxBoundsData;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.critereon.EnchantedItemTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/triggers/minecraft/enchanted_item", classExplaination="These are the functions which can be called on a minecraft:enchanted_item criteria trigger.")
public class EnchantedItemTriggerData
extends CriterionTriggerData {
    ItemPredicate itemPredicate = ItemPredicate.field_192495_a;
    private ItemBlockData itemData = new ItemBlockData();
    private MinMaxBoundsData levels = new MinMaxBoundsData();

    public EnchantedItemTriggerData(String criterionName, String advancementName) {
        super(criterionName, advancementName);
    }

    @Override
    public Criterion buildCriterion() throws Exception {
        ItemPredicate item = this.itemPredicate == ItemPredicate.field_192495_a ? this.itemData.buildItemPredicate() : this.itemPredicate;
        return new Criterion((ICriterionInstance)new EnchantedItemTrigger.Instance(item, this.levels.buildBounds()));
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="item data", notes="Sets the required item.")
    public void setItem(ItemBlockData data) throws Exception {
        this.itemPredicate = data.buildItemPredicate();
    }

    public ItemBlockData getItemData() {
        return this.itemData;
    }

    public void setItem(String itemName) {
        this.setItem(itemName, null);
    }

    public void setItem(String itemName, Integer meta) {
        this.itemData.setLocation(itemName);
        this.itemData.setMeta(meta != null ? new MinMaxBounds(Float.valueOf(meta.floatValue()), Float.valueOf(meta.floatValue())) : MinMaxBounds.field_192516_a);
    }

    public void setOreDict(String oreDict) throws Exception {
        this.itemData.setOre(oreDict);
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max level for the enchantment.")
    public void setLevelsMinMax(float min, float max) {
        this.levels.setMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min level for the enchantment.")
    public void setLevelsMin(float min) {
        this.levels.setMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max level for the enchantment.")
    public void setLevelsMax(float max) {
        this.levels.setMax(max);
    }
}

